<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnUpdateV63 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if ( Schema::hasTable('player_settings') ) {
            Schema::table('player_settings', function (Blueprint $table) {
                if (!Schema::hasColumn('player_settings', 'download')){
                    $table->string('download',191)->nullable();
                }
            });
        } 
        if ( Schema::hasTable('coupon_codes') ) {
            Schema::table('coupon_codes', function (Blueprint $table) {
                if (!Schema::hasColumn('coupon_codes','active')){
                    $table->boolean('active')->default(1);
                    }
            });
        } 
        if ( Schema::hasTable('custom_pages') ) {
            Schema::table('custom_pages', function (Blueprint $table) {
                if (!Schema::hasColumn('custom_pages','page_type')){
                    $table->string('page_type',191)->nullable();
                    }
            });
        } 
      if ( Schema::hasTable('configs') ) {
            Schema::table('configs', function (Blueprint $table) {
                if (!Schema::hasColumn('configs','otp_enable')){
                    $table->string('otp_enable',191)->nullable();
                    }
            });
        } 
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
